﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport marży zakupu wg kontrahentów</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
    <script runat="server">
        public enum SortowanieWedług { WgKoduKontrahenta, WgNazwyKontrahenta, WgWartościMalejąco }

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyKontrahenta;

            [DefaultWidth(50)]
            [Priority(1)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            int pierwszych = 0;

            [Priority(2)]
            public int Pierwszych {
                get { return pierwszych; }
                set { pierwszych = value; }
            }

			private bool _raportowacKwpz = false;
			
			[Soneta.Tools.Priority(3)]
			[Soneta.Types.Caption(@"Raportować KWPZ")]
			public bool RaportowacKwpz
			{
				get
				{
					return this._raportowacKwpz;
				}
				set
				{
					this._raportowacKwpz = value;
					OnChanged(EventArgs.Empty);
				}
			}
            public bool IsReadOnlyPierwszych() {
                return SortujWedług != SortowanieWedług.WgWartościMalejąco;
            }

        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly Kontrahent kontrahent;
            decimal znetto;
            decimal snetto;
            decimal zysk;
            decimal narzutp;
            decimal marzap;

            public Total(Kontrahent kontrahent) {
                this.kontrahent = kontrahent;
            }

            public void Add(ObrotyDokumentuZakupuWorker odzw) {
                znetto += odzw.WartośćZakupu;
				snetto += odzw.WartośćSprzedaży;
                zysk += odzw.WartośćSprzedaży - odzw.WartośćZakupu;
                narzutp += odzw.NarzutProcent;
                marzap += odzw.MarżaProcent;
            }

            public Kontrahent Kontrahent {
                get { return kontrahent; }
            }

            public decimal ZNetto {
                get { return znetto; }
            }

            public decimal SNetto {
                get { return snetto; }
            }

            public decimal Zysk {
                get { return zysk; }
            }

            public Percent NarzutProc {
                get {
                    if (znetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / znetto);
                }

            }

            public Percent MarzaProc {
                get {
                    if (snetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / snetto);
                }
            }

        }
        
        class NazwaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Nazwa;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Nazwa;
                return s1.CompareTo(s2);
            }
        }

        class KodComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Kontrahent == null ? "" : t1.Kontrahent.Kod;
                string s2 = t2.Kontrahent == null ? "" : t2.Kontrahent.Kod;
                return s1.CompareTo(s2);
            }
        }

        class WartośćComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                if (t1.ZNetto < t2.ZNetto) return 1;
                if (t1.ZNetto > t2.ZNetto) return -1;
                return 0;
            }
        }

        protected void dc_ContextLoad(object sender, EventArgs e) {

			ListaKWPZ.Visible = this.Parametry.RaportowacKwpz;

			if (this.Parametry.RaportowacKwpz)
			{
				this.LoadKWPZ();
			}
			
            ObrotyDokumentuZakupuWorker odzw = new ObrotyDokumentuZakupuWorker();
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();

            foreach (DokumentHandlowy dokh in rows) {
                odzw.Dokument = dokh;

				if (odzw.Dokument.Anulowany) continue;
                if (odzw.Dokument.Definicja.DuplikatWartosci) continue;
                if (odzw.Dokument.Kontrahent == null) continue;
                Total t = (Total)result[odzw.Dokument.Kontrahent];
                if (t == null) {
                    t = new Total(odzw.Dokument.Kontrahent);
                    result.Add(t.Kontrahent, t);
                }
                t.Add(odzw);
            }

            ArrayList lista = new ArrayList(result.Values);
            switch (Parametry.SortujWedług) {
                case SortowanieWedług.WgKoduKontrahenta:
                    lista.Sort(new KodComparer());
                    break;
                case SortowanieWedług.WgNazwyKontrahenta:
                    lista.Sort(new NazwaComparer());
                    break;
                case SortowanieWedług.WgWartościMalejąco:
                    lista.Sort(new WartośćComparer());
                    if (Parametry.Pierwszych > 0 && lista.Count > Parametry.Pierwszych)
                        lista.RemoveRange(Parametry.Pierwszych, lista.Count - Parametry.Pierwszych);
                    break;
            }
            Grid.DataSource = lista;

        }

        protected void Grid_BeforeRow(object sender, RowEventArgs args)
        {
            args.VisibleRow = (decimal)zakup.EditValue != 0m;
        }
        
		#region Lista KWPZ.

		private void LoadKWPZ()
		{
			HandelModule hm = HandelModule.GetInstance(dc);

			SubTable st;

			Magazyn magazyn = (Magazyn)dc[typeof(Magazyn)];
			if (magazyn == null)
				st = hm.DokHandlowe.WgDaty;
			else
				st = hm.DokHandlowe.WgMagazyn[magazyn];

			Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
				dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
			st = new SubTable(st, pars.Okres);

		Soneta.Business.View vwk = st.CreateView();
			vwk.Condition &= new FieldCondition.Equal("Definicja", hm.DefDokHandlowych.KorektaPZWZ);

			GridKor.DataSource = vwk;
		}

		protected void GridKor_BeforeRow(object sender, RowEventArgs args)
		{
			DokumentHandlowy dok = (DokumentHandlowy)args.Row;
			if (!testDok(dok))
				args.VisibleRow = false;
		}

		bool testDok(DokumentHandlowy dok)
		{
			foreach (DokumentHandlowy pz in dok.Nadrzędne)
			{
				if (pz.Definicja == dok.Module.DefDokHandlowych.KorektaPZWZ)
				{
					if (testDok(pz)) return true;
				}
				else if (pz.KierunekMagazynu == KierunekPartii.Przychód)
				{
					if (JestHandlowy(pz) || pz.DokumentyHandlowe.Length > 0) return true;
				}
			}
			return false;
		}
		private static bool JestHandlowy(DokumentHandlowy dok)
		{
			return KategoriaHandlowa.HandelPierwszy <= dok.Kategoria && dok.Kategoria <= KategoriaHandlowa.HandelOstatni;
		}
		void GridKor_AfterRender(Object sender, EventArgs args)
		{
			decimal v = ColZakupNettoK.TotalValue == null ? 0 : (decimal)ColZakupNettoK.TotalValue;
            v += zakup.TotalValue == null ? 0 : (decimal)zakup.TotalValue;
			ZakupyRazemLabel.EditValue = v;

			decimal vs = 0m;
			vs += sprzedaz.TotalValue == null ? 0 : (decimal)sprzedaz.TotalValue;
			ZyskRazemLabel.EditValue = vs - v;

			if (vs != 0)
				MarzaRazemLabel.EditValue = new Percent((vs - v) / vs);
			else
				MarzaRazemLabel.EditValue = Percent.Blank;

			if (v != 0)
				NarzutRazemLabel.EditValue = new Percent((vs - v) / v);
			else
				NarzutRazemLabel.EditValue = Percent.Blank;
		}

		#endregion	 
</script>

<body>
    <form id="Form1" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport marży zakupu wg kontrahentów|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres">
        </eb:ReportHeader>
		<font face="Verdana" size="2">Raport podaje koszty i przychody dla rozchodów związanych z danym zakupem, bez względu na terminy rozchodów. Korekty zakupu są wykazywane jako korekty kosztu dokumentami KWPZ. Raport uwzględnia dokumenty KWPZ  z zadanego okresu i do sprzedaży z tego okresu z pominięciem ich w okresach przyszłych.</font>
		<br />
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            FooterBorder="Single" ShowSum="MoreThenOne" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp."
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn2" runat="server" Caption="Kod" DataMember="Kontrahent.Kod" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn8" DataMember="Kontrahent.Nazwa" runat="server" Caption="Kontrahent" Total="Info" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="zakup" Width="13" Align="Right" Caption="Wartość~Zakupu" runat="server"
                    DataMember="ZNetto" Total="Sum" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn ID="sprzedaz" Width="13" Align="Right" Caption="Wartość~Sprzedaży" runat="server"
                    DataMember="SNetto" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="zysk" Width="13" Align="Right" Caption="Wartość~Marża"
                    runat="server" DataMember="Zysk" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="narzut" Width="10" Align="Right" Caption="Narzut %" runat="server"
                    DataMember="NarzutProc" >
                </ea:GridColumn>
                <ea:GridColumn ID="marza" Width="10" Align="Right" Caption="Marża %" runat="server"
                    DataMember="MarzaProc" >
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
       <ea:Section ID="ListaKWPZ" runat="server" Width="100%" >
				<font face="Verdana" size="2">Korekty sprzedaży wynikające z korekt zakupu</font>
				<br />
				<ea:grid id="GridKor" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
					OnAfterRender="GridKor_AfterRender" OnBeforeRow="GridKor_BeforeRow">
					<Columns>
						<ea:GridColumn runat="server" Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="40" DataMember="DokumentMagazynowyNumer" Caption="Dokument magazynowy~Numer" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="15" DataMember="DokumentMagazynowyData" Caption="Dokument magazynowy~Data" EncodeHTML="True"></ea:GridColumn>
						<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="WartośćWCenieZakupu" Total="Sum" Caption="Korekta|wartości zakupu|netto"
							Format="{0:n}" ID="ColZakupNettoK" EncodeHTML="True"></ea:GridColumn>
					</Columns>
				</ea:grid><br />
				<font face="Verdana" size="2">Wartość zakupu razem:
					<ea:DataLabel id="ZakupyRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN<br />
					Zysk razem:
					<ea:DataLabel id="ZyskRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>&nbsp;PLN, 
					marża:
					<ea:DataLabel id="MarzaRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel>, narzut:
					<ea:DataLabel id="NarzutRazemLabel" runat="server" EncodeHTML="True"></ea:DataLabel><br />
				</font>
				</ea:Section> 
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

